import { useEditor, useValue } from "@tldraw/editor";
import { useCallback, useEffect, useRef } from "react";
import { useUiEvents } from "../context/events.mjs";
function useMenuIsOpen(id, cb) {
  const editor = useEditor();
  const rIsOpen = useRef(false);
  const trackEvent = useUiEvents();
  const onOpenChange = useCallback(
    (isOpen2) => {
      rIsOpen.current = isOpen2;
      editor.run(() => {
        if (isOpen2) {
          editor.complete();
          editor.addOpenMenu(id);
        } else {
          editor.updateInstanceState({
            openMenus: editor.getOpenMenus().filter((m) => !m.startsWith(id))
          });
        }
        cb?.(isOpen2);
      });
    },
    [editor, id, cb]
  );
  const isOpen = useValue("is menu open", () => editor.getOpenMenus().includes(id), [editor, id]);
  useEffect(() => {
    if (rIsOpen.current) {
      trackEvent("open-menu", { source: "unknown", id });
      editor.addOpenMenu(id);
    }
    return () => {
      if (rIsOpen.current) {
        editor.deleteOpenMenu(id);
        editor.getOpenMenus().forEach((menuId) => {
          if (menuId.startsWith(id)) {
            trackEvent("close-menu", { source: "unknown", id });
            editor.deleteOpenMenu(menuId);
          }
        });
        rIsOpen.current = false;
      }
    };
  }, [editor, id, trackEvent]);
  return [isOpen, onOpenChange];
}
export {
  useMenuIsOpen
};
//# sourceMappingURL=useMenuIsOpen.mjs.map
